/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.tags;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.utils.Array;
import technology.rocketjump.undermount.assets.entities.tags.Tag;
import technology.rocketjump.undermount.assets.entities.tags.TagProcessingUtils;
import technology.rocketjump.undermount.entities.components.AttachedLightSourceComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.rendering.HexColors;
import technology.rocketjump.undermount.rendering.utils.ColorMixer;

public class AttachedLightSourceTag
extends Tag {
    @Override
    public boolean isValid() {
        return this.args.size() == 1;
    }

    @Override
    public void apply(Entity entity, TagProcessingUtils tagProcessingUtils) {
        AttachedLightSourceComponent attachedLightSourceComponent = entity.getComponent(AttachedLightSourceComponent.class);
        if (attachedLightSourceComponent == null) {
            attachedLightSourceComponent = new AttachedLightSourceComponent(entity);
            attachedLightSourceComponent.updatePosition();
            entity.addComponent(attachedLightSourceComponent);
        }
        String colourType = (String)this.args.get(0);
        Color lightColor = ColorMixer.randomBlend(new RandomXS128(entity.getId()), AttachedLightSourceTag.getColors(colourType));
        attachedLightSourceComponent.setColor(lightColor);
    }

    private static Array<Color> getColors(String colourType) {
        Array<Color> colors = new Array<Color>();
        if (colourType.equals("ORANGE")) {
            colors.add(HexColors.get("#fff95b"));
            colors.add(HexColors.get("#ffe487"));
            colors.add(HexColors.get("#ffd39f"));
            colors.add(HexColors.get("#ffb99e"));
        } else if (colourType.equals("GREEN")) {
            colors.add(HexColors.get("#85f3ce"));
            colors.add(HexColors.get("#a7f3c3"));
            colors.add(HexColors.get("#d9ffda"));
            colors.add(HexColors.get("#cdffb7"));
        } else {
            System.err.println("Not yet implemented attached light source color: " + colourType);
            colors.add(Color.WHITE);
        }
        return colors;
    }
}

